//AIM:Computation of N-Point DFT using DIT method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={1,2,3,4,5,6} using DIT
//(Split radix) method for N=6(2*3)
x0=1;//DIT-FFT,so arranging the input in shuffled  order
x2=3;//DIT-FFT,so arranging the input in decimated  order
x4=5;//DIT-FFT,so arranging the input in decimated  order
x1=2;//DIT-FFT,so arranging the input in decimated  order
x3=4;//DIT-FFT,so arranging the input in decimated  order
x5=6;//DIT-FFT,so arranging the input in decimated  order

// Twiddle factors
W0=cos(((2*%pi)/6)*0)-sqrt(-1)*sin(((2*%pi)/6)*0)
W1=cos(((2*%pi)/6)*1)-sqrt(-1)*sin(((2*%pi)/6)*1)
W2=cos(((2*%pi)/6)*2)-sqrt(-1)*sin(((2*%pi)/6)*2)
W3=cos(((2*%pi)/6)*3)-sqrt(-1)*sin(((2*%pi)/6)*3)
W4=cos(((2*%pi)/6)*4)-sqrt(-1)*sin(((2*%pi)/6)*4)
W5=cos(((2*%pi)/6)*5)-sqrt(-1)*sin(((2*%pi)/6)*5)
W6=cos(((2*%pi)/6)*6)-sqrt(-1)*sin(((2*%pi)/6)*6)

// Stage 1 computation
X0a=x0+x2+x4
X1b=x0+x2*W2+x4*W4;//at line 2 x2 and x4 are to be multiplied by twiddle factor of W2 and W4 respectively
X2c=x0+x2*W4+x4*W2;//at line 3 x2 and x4 are to be multiplied by twiddle factor of W4 and W2 respectively
X3d=x1+x3+x5
X4e=x1+x3*W2+x5*W4;//at line 5 x3 and x5 are to be multiplied by twiddle factor of W2 and W4 respectively
X5f=x1+x3*W4+x5*W2;//at line 6 x2 and x4 are to be multiplied by twiddle factor of W4 and W2 respectively

// Stage 2 computation
X0=X0a+X3d
X1=X1b+X4e*W1;//at line 2 X4e is to be multiplied by factor W1
X2=X2c+X5f*W2;//at line 3 X5f is to be multiplied by factor W2
X3=X0a+X3d*W3;//at line 4 X3d is to be multiplied by factor W3
X4=X1b+X4e*W4;//at line 5 X4e is to be multiplied by factor W4
X5=X2c+X5f*W5;//at line 6 X5f is to be multiplied by factor W5

//displaying the output
disp(X0,"X0=")
disp(X1,"X1=")
disp(X2,"X2=")
disp(X3,"X3=")
disp(X4,"X4=")
disp(X5,"X5=")
disp({X0,X1,X2,X3,X4,X5},'So,the DFT of x(n) using Decimation-in-Frequency Fast Fourier Transform(DIF-FFT) is X(k)=')

//Expected output:X(k)={21,-3+5.1961524i,-3+1.7320508i,-3,-3-1.7320508i,-3- 5.1961524i}

